--********************************DISCLAIMER**************************************
--We do not support 32-bit versions of SQL Server due to memory constraints
--********************************************************************************

--********************************************************************************
--If you should have any comments, suggestions or improvements to these samples, 
--we welcome you to contact us at SampleCode@melissadata.com also please visit our 
--developers bulletin board at forum.melissadata.com.
--********************************************************************************


SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

DROP PROCEDURE sp_VerifyAddress
GO

CREATE PROCEDURE sp_VerifyAddress AS

-- DECLARE variables.
DECLARE @DataPath  char(100)
DECLARE @License char(256)
DECLARE @intResult int
DECLARE @intObject int
DECLARE @intRetval int
DECLARE @strRetval char(100)
DECLARE @initError char(100) 
DECLARE @RecCnt float
DECLARE @Company char(40)
DECLARE @Address char(32)
DECLARE @Suite char(10)
DECLARE @City char(28)
DECLARE @State char(2)
DECLARE @Zip char(5)
DECLARE @Plus4 char(4)
DECLARE @DeliveryPointCode char(2)
DECLARE @DeliveryPointCheckDigit char(1)
DECLARE @Results char(25)
DECLARE @PrivateMailbox char(10)


-- DECLARE a cursor from table name LIST
DECLARE AddCursor cursor for select company, address, city, state, zip from LIST

-- ********************** DATA FILES  *****************************
--  Set Path to Data Files and License String Here
--  The Data Files Directory must contain the following files: 
--  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str.
-- ****************************************************************
SET  @DataPath = 'C:\Program Files\Melissa DATA\DQT\Data'

-- ********************** LICENSE STRINGS *************************
--       To unlock the full functionality of Address Object,      
--   please call a sales representative at 1-800-MELISSA ext. 3    
--           (1-800-635-4772 x3) for a license string.            
--       Without a valid license string, Address Object will      
--                  only verify Nevada addresses.                 
--   SetLicenseString also checks for a valid license in the 
--   MDADDR_LICENSE environment variable. 
--   This allows you to modify the license without recompilation.
-- **************************************************************** 
SET  @License = 'Demo'


SET  @RecCnt = 0	-- Record count
SET  nocount on		

-- Create Address Object.
EXEC @intResult = sp_OACreate 'AddressObject.AddressCheck', @intObject OUT
IF @intResult <> 0
BEGIN
    RAISERROR ('Object Creation Error', 1, 2)
    RETURN
END  
EXEC @intResult = sp_OAMethod @intObject, SetLicenseString,  @strRetval OUT, @License


-- Set Path To US Data Files
 EXEC sp_OASetProperty @intObject, PathToUSFiles, @DataPath

-- DPV and LACSLink, CASS required add-ons for highest level of validation. Should be used by non-demo users.
 EXEC @intResult = sp_OASetProperty @intObject, PathToDPVDataFiles, @DataPath
 EXEC @intResult = sp_OASetProperty @intObject, PathToLACSLinkDataFiles, @DataPath

-- Suite Link 
 EXEC @intResult = sp_OASetProperty @intObject, PathToSuiteLinkDataFiles, @DataPath

-- RDBI - Delivery Indicator Add-on (Residence or Business) 
-- EXEC @intResult = sp_OASetProperty @intObject, PathToRBDIFiles @DataPath

-- Canadian - Canadian Address Validation Add-on
-- EXEC @intResult = sp_OASetProperty @intObject, PathToCanadaFiles @DataPath


--Get Build Number
EXEC @intResult = sp_OAMethod @intObject, GetBuildNumber,  @strRetval OUT
PRINT 'Build Number=' + @strRetval

-- Initialize data file - use the default
EXEC @intResult = sp_OAMethod @intObject, InitializeDataFiles, @intRetval OUT
IF @intResult <> 0 OR @intRetval <> 0	-- Intialization failed
BEGIN
	EXEC @intResult = sp_OAMethod @intObject, GetInitializeErrorString, @initError OUT
	PRINT 'Data File Initialization Error=' + @initError
	RAISERROR ('Initialize Error',  1, 2) 
    	RETURN
END  

--Get Database Date
EXEC @intResult = sp_OAMethod @intObject, GetUSDatabaseDate,  @strRetval OUT
PRINT 'Database Date=' + @strRetval

--Get Expiration Date
EXEC @intResult = sp_OAMethod @intObject, GetUSExpirationDate,  @strRetval OUT
PRINT 'Database Expiration Date=' + @strRetval

OPEN AddCursor

-- Perform the first fetch.
FETCH NEXT FROM AddCursor INTO @Company, @Address, @City, @State, @Zip

-- Check FETCH_STATUS to see if there are any more rows to fetch.
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @RecCnt = @RecCnt + 1	

	--Clear and Set Properities the Address
	EXEC @intResult = sp_OAMethod @intObject, ClearProperties
	EXEC @intResult =sp_OASetProperty @intObject, company, @company
	EXEC @intResult =sp_OASetProperty @intObject, Address, @Address
	EXEC @intResult =sp_OASetProperty @intObject, City, @City
	EXEC @intResult =sp_OASetProperty @intObject, State, @State
	EXEC @intResult =sp_OASetProperty @intObject, Zip, @Zip
	-- Set the Last Name Input Property for SuiteFinder Add-on
	 EXEC @intResult =sp_OASetProperty @intObject, LastName, 'Last Name Here'

	-- Call the Verify Address method
	EXEC @intResult = sp_OAMethod @intObject, VerifyAddress, @intRetval OUT
	IF @intResult <> 0
	BEGIN
		PRINT 'Error=' + str(@intResult)
		RAISERROR ('VerifyAddress Method Error',  1, 2) 
		RETURN
	END  

	-- Use this statement to do special processing if the address was validated or not
	--IF @intRetval <> 1
		--Problem with address found
	--	SET @Dash = ' ' -- Don't show a dash between the ZIP Code and Plus4
	--ELSE
		--Address was verified
	--	SET @Dash = '-' -- Show a dash between the ZIP Code and Plus4

	-- Retrieve information from the COM object
	EXEC @intResult =sp_OAGetProperty @intObject, Address, @Address OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Suite, @Suite OUT
	EXEC @intResult =sp_OAGetProperty @intObject, City, @City OUT
	EXEC @intResult =sp_OAGetProperty @intObject, State, @State OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Zip, @Zip OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Plus4, @Plus4 OUT
	EXEC @intResult =sp_OAGetProperty @intObject, DeliveryPointCode, @DeliveryPointCode OUT
	EXEC @intResult =sp_OAGetProperty @intObject, DeliveryPointCheckDigit, @DeliveryPointCheckDigit OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Results, @Results OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Suite, @Suite OUT
	EXEC @intResult =sp_OAGetProperty @intObject, PrivateMailbox, @PrivateMailbox OUT


	-- Update the table with new information
	UPDATE LIST SET Address_Output = rtrim(@Address), 
                    City			= @City, 
                    State			= @State, 
                    Zip				= @Zip,
                    Plus4			= @Plus4,
                    DPC				= @DeliveryPointCode + @DeliveryPointCheckDigit, 
                    Suite			= @Suite,
					Results			= @Results,
					PrivateMailbox	= @PrivateMailbox where current of AddCursor

	-- Get next record	
	FETCH NEXT FROM AddCursor into @Company, @Address, @City, @State, @Zip
END

--Close and de-allocate cursor
CLOSE AddCursor
DEALLOCATE AddCursor

-- Destroy Address Object.
EXEC @intResult = sp_OADestroy @intObject
IF @intResult <> 0
BEGIN
    RAISERROR ('Destroy Object Error', 1, 2)
    RETURN
END



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

